<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\BeneficioNivel;
use App\Models\Beneficio;
use App\Repositories\BeneficioRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Tools;
use DB;

class BeneficioAPIController extends Controller
{
    private $beneficioNivelRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(BeneficioRepository $beneficioRepository)
    {
        $this->beneficioRepository = $beneficioRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {


    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(Beneficio $beneficio)
    {
        //
    }


    public function getBeneficios($id)
    {
        $beneficios = Beneficio::where('idbeneficio_nivel',$id)->get();//->orderBy("id", "asc");

        if ($beneficios->isEmpty()) {
            return $this->sendError('Lista de Beneficio vacia');
        } else {
            return $this->sendResponse($beneficios, 401);
        }
    }

    
    public function getBeneficiosByNivel()
    {

        $beneficios = Beneficio::whereNull('deleted_at')
                ->orderBy('idbeneficio_nivel')
                ->orderBy('id')
                ->get();

//        $beneficios = Beneficio::whereNull('deleted_at')->get();//->orderBy("id", "asc");

        if ($beneficios->isEmpty()) {
            return $this->sendError('Lista de Beneficio vacia');
        } else {
            return $this->sendResponse($beneficios, 401);
        }
    }

    public function getBeneficiosTemp()
    {
        $results = DB::table('beneficio')
        ->join('beneficio_nivel', 'beneficio.idbeneficio_nivel', '=', 'beneficio_nivel.id')
        ->select('beneficio_nivel.nombre as nombre_nivel', DB::raw('COUNT(*) as count'))
        ->groupBy('nombre_nivel')
        ->orderBy('nombre_nivel')
        ->get();
    
        if ($results->isEmpty()) {
            return $this->sendError('Lista de Beneficio vacia');
        } else {
            return $this->sendResponse($results, 401);
        }

        

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(EstadoCivil $estadoCivil)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(EstadoCivil $estadoCivil)
    {
        //
    }


}
