<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;

use App\Models\Promocion;
use App\Models\PromocionNotificacion;
use App\Models\Cliente;
use App\Repositories\PromocionRepository;

use Illuminate\Http\Request;
use App\Http\Controllers\Tools;
use DB;
use Illuminate\Support\Collection;
use Illuminate\Support\Carbon;

class PromocionAPIController extends Controller
{
    private $promocionRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(PromocionRepository $promocionRepository)
    {
        $this->promocionRepository = $promocionRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(Beneficio $beneficio)
    {
        //
    }

    public function sendNotificacionesPromociones(Request $request)
    {
        //Tipo 1: Publicidad
        //Tipo 2: Promocion

        // Consulta para obtener las notificaciones con fecha anterior a ahora
        $notificaciones = PromocionNotificacion::whereDate('fecha_notificacion', '<', DB::raw('NOW()'))->where('enviado', false)->get();
        /*  Carbon::now()
        $notificaciones = DB::table('promocion_notificacion')
        ->where('fecha_notificacion', '<', DB::raw('NOW()'))
        ->get();
        */
        //echo $notificaciones;
        //return $this->sendError('Envío realizado');
    
        // Recorre las notificaciones y haz lo que necesites con ellas
        foreach ($notificaciones as $notificacion) 
        {
            //$notificacion->enviado = true;
            //$notificacion->save();


            // Crear una colección vacía de appIds
            $finalappIds = new Collection();

            $sucursalesString = $notificacion->sucursales;
            // Divide el string en un arreglo utilizando la coma como delimitador
            $sucursalesArray = explode(',', $sucursalesString);

            foreach ($sucursalesArray as $idsucursal) 
            {

                $data= array(
                    'id_sucursal'=> $idsucursal,
                    'id_promocion'=>$notificacion->id_promocion_foliatti
                );

                //echo "ID de Sucursal: " . $data['id_sucursal'] . "\n";
                //echo "ID de Promoción: " . $data['id_promocion'] . "\n";

                $url = env('APP_FOLIATTIAPI_URL') . "PromoEvent/getParticipantes";
                $method="POST";
                $output = (new Tools)->CallAPI($method, $url, json_encode($data));
                $result = json_decode($output);
                
                $appIdsArray = $result->appIds;

                //echo "Tamaño de los ids: " . count($appIdsArray) . "\n";

                if (!empty($appIdsArray)) 
                {
                    foreach ($appIdsArray as $appId) 
                    {
                        $finalappIds->push($appId);
                    }
                }

            }
          

            // Obtener todos los números únicos
            $appIdsunicos = $finalappIds->unique();
            $deviceTokens = array();            
            $deviceIndex = 0;

            // Consulta para obtener los clientes cuyos IDs están en $appIdsunicos
            $clientes = Cliente::whereIn('id', $appIdsunicos)->whereNotNull('firebase_token')->get();

            // Recorre los clientes y haz lo que necesites con ellos
            foreach ($clientes as $cliente) 
            {
                $deviceTokens[$deviceIndex] = $cliente->firebase_token;
                $deviceIndex++;      
            }
            
            //Envío de la notificación
            // URL de la API de FCM
            $url = 'https://fcm.googleapis.com/fcm/send';

            // Clave de servidor de Firebase
            $server_key = 'AAAAl87fw7A:APA91bH3GQ2gboxe_ARJfKdUSiW4gzsfgjL53dbH8oYaCLtSdgYONaI0Eb96yHF4CSTVm_pF3J9pkXuCcVAT8Wpt6C0KUNK-7K2UTf6MvmupVkiprBlrvhTC0v2Htk1N0scdqW6fiL26';

            // Encabezados de la solicitud HTTP
            $headers = array(
                'Authorization: key=' . $server_key,
                'Content-Type: application/json'
            );

            // Datos de la notificación
            $data = array(
            //    'to' => 'cE-bD3uIRIesAY-jEgCLxw:APA91bEFZXYkCNv-wQIOYLBjtzOUNtu2WjhcRe-3hnMDojRTdR8PT3jIjVcm8JkJHEJENgzN45xxKzCB3IQFAG1cTGgKfM6HviOv1ACqmj3ShsNgkj_pI6gP-O-fzKW5fQyH4QWHzZGf',
                'registration_ids' => $deviceTokens,
                'notification' => array(
                    'title' => $notificacion->titulo,
                    'body' => $notificacion->mensaje
                )
            );

            // Configuración de la solicitud HTTP
            $options = array(
                'http' => array(
                    'header'  => implode("\r\n", $headers),
                    'method'  => 'POST',
                    'content' => json_encode($data)
                )
            );

            // Crear contexto de la solicitud HTTP
            $context  = stream_context_create($options);

            // Enviar la solicitud HTTP
            $result = file_get_contents($url, false, $context);            



            $notificacion->enviado = true;
            $notificacion->save();
        }        

        


            return $this->sendError('Envío realizado');
            //return $this->sendResponse($promociones, 401);
    }    

    public function getPromociones(Request $request, $tipo)
    {
        //Tipo 1: Publicidad
        //Tipo 2: Promocion

        $idcliente = $request->input('idcliente');


       // $recompensas = Recompensa::select(Recompensa::raw("select * from recompensa"));
      /* $promociones = DB::table('promocion')
       ->selectRaw('*')
       ->where('status', true)
       ->where('tipo', $tipo)
       ->whereIn('promocion.id', function($query) use ($idsucursal) {
           $query->select('idpromocion')
               ->from('promocion_sucursal')
               ->where('idsucursal', $idsucursal);
       })
       ->get();
*/
       $promociones = DB::table('promocion')
       ->where('status', '=', true)
       ->where('tipo', '=', $tipo)
       ->where('deleted_at', null)
       ->whereIn('promocion.id', function($query) use ($idcliente){
           $query->select('idpromocion')
                 ->from('promocion_sucursal')
                 ->whereIn('idsucursal', function($query) use ($idcliente) {
                     $query->select('idsucursal')
                           ->from('cliente_sucursal')
                           ->where('idcliente', '=', $idcliente);
                 });
       })
       ->get();




        if ($promociones->isEmpty()) {
            return $this->sendError('Lista de promociones vacia');
        } else {
            return $this->sendResponse($promociones, 401);
        }
    }

    public function getRecompensaPromocionales(Request $request, $idrecompensa_categoria)
    {
        $idsucursal = $request->input('idsucursal');

       // $recompensas = Recompensa::select(Recompensa::raw("select * from recompensa"));
       $recompensas_promocionales = DB::table('recompensa_promocional')
       ->where('deleted_at', null)
       ->whereIn('idrecompensa', function($query) use ($idrecompensa_categoria, $idsucursal){
           $query->select('recompensa.id')
               ->from('recompensa')
               ->where('status', true)
               ->whereRaw("CAST((CONCAT(inicio_fecha, ' ', inicio_hora)) AS timestamp) <= now()")
               ->whereRaw("CAST((CONCAT(fin_fecha, ' ', fin_hora)) AS timestamp) > now()")
               ->where('idrecompensa_categoria', $idrecompensa_categoria)
               ->whereIn('recompensa.id', function($query) use ($idsucursal) {
                   $query->select('idrecompensa')
                       ->from('recompensa_sucursal')
                       ->where('idsucursal', $idsucursal);
               });
       })
       ->get();

        if ($recompensas_promocionales->isEmpty()) {
            return $this->sendError('Lista de Recompensa Promocionales vacia');
        } else {
            return $this->sendResponse($recompensas_promocionales, 401);
        }
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(EstadoCivil $estadoCivil)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(EstadoCivil $estadoCivil)
    {
        //
    }


}
