<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;

use App\Models\Recompensa;
use App\Repositories\RecompensaRepository;
use App\Models\RecompensaPromocional;
use App\Repositories\RecompensaPromocionalRepository;

use Illuminate\Http\Request;
use App\Http\Controllers\Tools;
use DB;

class RecompensaAPIController extends Controller
{
    private $recompensaNivelRepository;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(RecompensaRepository $recompensaNivelRepository)
    {
        $this->recompensaNivelRepository = $recompensaNivelRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

		$this->validate($request, [
            'nombre' => 'required',

        ]);

        try {
            $marca = $this->colorRepository->create(array(
                'nombre' => $request->nombre,
				'activo' => true,
				'codigo' => '1',

            ));


		} catch (ValidatorException $e) {
            return $this->sendError($e->getMessage(), '401');
        }

        return $this->sendResponse($marca->toArray(), 'Estado Civil agregado correctamente');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function show(Beneficio $beneficio)
    {
        //
    }


    public function getRecompensas(Request $request, $idrecompensa_categoria)
    {
        $idsucursal = $request->input('idsucursal');

       // $recompensas = Recompensa::select(Recompensa::raw("select * from recompensa"));
       $recompensas = DB::table('recompensa')
       ->selectRaw('*')
       ->where('deleted_at', null)
       ->where('status', true)
       ->whereRaw("CAST((CONCAT(inicio_fecha, ' ', inicio_hora)) AS timestamp) <= now()")
       ->whereRaw("CAST((CONCAT(fin_fecha, ' ', fin_hora)) AS timestamp) > now()")
       ->where('idrecompensa_categoria', $idrecompensa_categoria)
       ->whereIn('recompensa.id', function($query) use ($idsucursal) {
           $query->select('idrecompensa')
               ->from('recompensa_sucursal')
               ->where('idsucursal', $idsucursal);
       })
       ->get();



        if ($recompensas->isEmpty()) {
            return $this->sendError('Lista de Recompensas vacia');
        } else {
            return $this->sendResponse($recompensas, 401);
        }
    }

    public function getRecompensaPromocionales(Request $request, $idrecompensa_categoria)
    {
        $idsucursal = $request->input('idsucursal');

       // $recompensas = Recompensa::select(Recompensa::raw("select * from recompensa"));
       $recompensas_promocionales = DB::table('recompensa_promocional')
       ->where('deleted_at', null)
       ->whereIn('idrecompensa', function($query) use ($idrecompensa_categoria, $idsucursal){
           $query->select('recompensa.id')
               ->from('recompensa')
               ->where('status', true)
               ->whereRaw("CAST((CONCAT(inicio_fecha, ' ', inicio_hora)) AS timestamp) <= now()")
               ->whereRaw("CAST((CONCAT(fin_fecha, ' ', fin_hora)) AS timestamp) > now()")
               ->where('idrecompensa_categoria', $idrecompensa_categoria)
               ->where('deleted_at', null)
               ->whereIn('recompensa.id', function($query) use ($idsucursal) {
                   $query->select('idrecompensa')
                       ->from('recompensa_sucursal')
                       ->where('idsucursal', $idsucursal);
               });
       })
       ->get();

        if ($recompensas_promocionales->isEmpty()) {
            return $this->sendError('Lista de Recompensa Promocionales vacia');
        } else {
            return $this->sendResponse($recompensas_promocionales, 401);
        }
    }



    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function edit(EstadoCivil $estadoCivil)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\color  $color
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Color  $color
     * @return \Illuminate\Http\Response
     */
    public function destroy(EstadoCivil $estadoCivil)
    {
        //
    }


}
