<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Sucursal;
use App\Repositories\SucursalRepository;
use Illuminate\Http\Request;
use DB;

class SucursalAPIController extends Controller
{
    private $sucursalRepository;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(SucursalRepository $sucursalRepository)
    {
        $this->sucursalRepository = $sucursalRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
        //
    }


    public function getSucursales($idcompany){
        $sucursal = Sucursal::where('idcompany', $idcompany)->join('company', 'company.id', '=' , 'sucursal.idcompany')
                                                                            ->select('sucursal.*', 'company.nombre as NombreCompany')->where('sucursal.status', '=', true)->get();

        if(empty($sucursal)){
            return $this->sendError('No hay sucursales asignadas a esta compania');
        }else {
            return $this->sendResponse($sucursal, 'Lista de sucursales de esta compania');
        }   

    }

    public function getSucursalesNoVinculadas($idcliente){
        
        $sucursales = DB::table('sucursal')
    ->where('idcompany', 1)
    ->where('status', true)
    ->whereNull('deleted_at')
    ->whereNotIn('id', function($query) use ($idcliente) {
        $query->select('idsucursal')
            ->from('cliente_sucursal')
            ->where('idcliente', $idcliente);
    })
    ->orderBy('nombre')
    ->get();


        if(empty($sucursales)){
            return $this->sendError('No hay sucursales pendientes de vinculra para este cliente');
        }else {
            return $this->sendResponse($sucursales, 'Lista de sucursales No Vinculadas al cliente');
        }   

    }

    


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function destroy()
    {
        //
    }
}
