<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\VehiculoValet;
use App\Repositories\VehiculoValetRepository;
use Illuminate\Http\Request;

class VehiculoValetAPIController extends Controller
{
    private $vehiculovaletRepository;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(VehiculoValetRepository $vehiculovaletRepository)
    {
        $this->vehiculovaletRepository = $vehiculovaletRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
        //
    }


    public function getVehiculoAsignados($idempleado){
        $vehiculoValet = VehiculoValet::where('idempleado', $idempleado)->join('vehiculos', 'vehiculos.id', '=' , 'vehiculo_valet.idvehiculo')
                                                                        ->join('statusvehiculo', 'statusvehiculo.id', '=', 'vehiculos.idstatus')
                                                                        ->Join('estacionamientocajon', 'estacionamientocajon.id', '=' , 'vehiculo_valet.idestacionamientocajon')
                                                                        ->select('vehiculo_valet.*', 'vehiculos.placas as placas', 'estacionamientocajon.nombre as Ubicacion', 'statusvehiculo.nombre as Estatus')->get();

        if(empty($vehiculoValet)){
            return $this->sendError('No hay vehiculos asignados');
        }else {
            return $this->sendResponse($vehiculoValet, 'Vehiculos Asignados');
        }   

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function update()
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Vehiculo  $vehiculo
     * @return \Illuminate\Http\Response
     */
    public function destroy()
    {
        //
    }
}
