<?php

namespace App\Http\Controllers;

use App\Exceptions\InvalidRequestException;
use App\Models\Roles;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Routing\Route;
use App\Http\Controllers\exception;
use App\Http\Controllers\Permission;

use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Authh;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Models\Beneficio;
use App\Models\BeneficioNivel;

class BeneficiosController extends Controller
{
    use HasRoles;

    public function __construct()
    {
        $this->middleware('permission:listar_beneficios', ['only' => ['index','list']]);
        $this->middleware('permission:crear_beneficios', ['only' => ['create','store']]);
        $this->middleware('permission:editar_beneficios', ['only' => ['edit','update']]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $niveles = BeneficioNivel::where('status', true)->orderBy('id')->get();
        return view('Beneficios.beneficios_index', compact('niveles'));
    }

    public function list($nivel)
    {
        $beneficios = Beneficio::where('idbeneficio_nivel', $nivel)->get();
        session()->flash('seleccion-nivel', $nivel);
        return view('Beneficios.beneficios_list', compact('beneficios'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $nivel = BeneficioNivel::findOrFail($request->nivel);
        
        return view('Beneficios.beneficios_create', compact('nivel'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            /*if(Beneficio::whereRaw("nombre ilike '$request->nombre'")->exists()){
                throw new \Exception("El nombre ya existe", 1);
            }

            if(Beneficio::whereRaw("codigo ilike '$request->codigo'")->exists()){
                throw new \Exception("El código ya existe", 1);
            }*/

            DB::beginTransaction();           

            $img = getB64Image($request->imagen);
            $img_extension = getB64Extension($request->imagen);
            if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif'])){
                throw new \Exception("Extensión de imagen inválida", 1);
            }

            $img_name = 'img_beneficio'. time() . '.' . $img_extension;

            $oBeneficio = new Beneficio();
            $oBeneficio->idbeneficio_nivel = $request->id_nivel;
            $oBeneficio->nombre = $request->nombre;
            $oBeneficio->descripcion = $request->descripcion;
            $oBeneficio->codigo = $request->codigo;
            $oBeneficio->status = $request->status == 'true';
            $oBeneficio->imagen = $img_name;
            $oBeneficio->save();

            //Save with full path
            $img_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'beneficios/' . $oBeneficio->id . '/' .   $img_name;
            $oBeneficio->imagen_fullpath = $img_name_DB;            
            $oBeneficio->save();
            
            Storage::disk('beneficio')->put($oBeneficio->id . '/' .$img_name, $img);

            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();

            throw new InvalidRequestException($e->getMessage());
        }

        session()->flash('seleccion-nivel', $request->id_nivel);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $beneficio = Beneficio::findOrFail($id);
        $nivel = $beneficio->nivel;

        return view('Beneficios.beneficios_create', compact('beneficio','nivel'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            if(Beneficio::whereRaw("nombre ilike '$request->nombre'")->where('id','<>',$id)->exists()){
                throw new \Exception("El nombre ya existe", 1);
            }

            if(Beneficio::whereRaw("codigo ilike '$request->codigo'")->where('id','<>',$id)->exists()){
                throw new \Exception("El código ya existe", 1);
            }

            $oBeneficio = Beneficio::findOrFail($id);           

            DB::beginTransaction();           

            $oBeneficio->idbeneficio_nivel = $request->id_nivel;
            $oBeneficio->nombre = $request->nombre;
            $oBeneficio->descripcion = $request->descripcion;
            $oBeneficio->codigo = $request->codigo;
            $oBeneficio->status = $request->status == 'true';

            $imagenDelete = null;
            if($request->imagen != ''){
                $imagenDelete = $oBeneficio->imagen;
                $img = getB64Image($request->imagen);
                $img_extension = getB64Extension($request->imagen);
                if(!in_array($img_extension, ['jpg', 'jpeg', 'png', 'gif'])){
                    throw new \Exception("Extensión de imagen inválida", 1);
                }
                $img_name = 'img_beneficio'. time() . '.' . $img_extension;

                //Save with full path
                $img_name_DB = env('APP_FOLIATTI_IMG_PATH') . 'beneficios/' . $oBeneficio->id . '/' .   $img_name;

                $oBeneficio->imagen = $img_name;
                $oBeneficio->imagen_fullpath = $img_name_DB;

                Storage::disk('beneficio')->put($oBeneficio->id . '/' .$img_name, $img);
            }            
            $oBeneficio->save();
            
            DB::commit();

            if(!is_null($imagenDelete)){
                Storage::disk('beneficio')->delete($oBeneficio->id . '/' .$imagenDelete);
            }
        } catch (\Exception $e) {
            DB::rollback();

            throw new InvalidRequestException($e->getMessage());
        }

        session(['seleccion-nivel' => $request->id_nivel]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $oBeneficio = Beneficio::findOrFail($id);
        $oBeneficio->delete();
    }

}
