<?php

namespace App\Http\Controllers;

use App\Exceptions\InvalidRequestException;
use App\Models\Sucursal;
use GrahamCampbell\ResultType\Success;
use Illuminate\Http\Request;
use SebastianBergmann\Environment\Console;

class SucursalesController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $sucursales = Sucursal::all();

        return view('Sucursal.Sucursal_list', compact('sucursales'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view("Sucursal.Sucursal_create");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            Sucursal::create([
                'nombre' => $request->nombre,
                'codigo' => $request->codigo,
                'status' => $request->status
            ]);
        } catch (\Exception $e) {

            throw new InvalidRequestException($e->getMessage());
        }

        return redirect()->route("sucursales.index")->with(["mensaje" => "Scursal creada",]);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Sucursal  $sucursal
     * @return \Illuminate\Http\Response
     */
    public function show(Sucursal $sucursal)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Sucursal  $sucursal
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        try {
            $sucursal = Sucursal::findOrFail($id);
        } catch (\Exception $e) {

            throw new InvalidRequestException($e->getMessage());
        }
        return view('Sucursal.Sucursal_edit', compact('sucursal'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Sucursal  $sucursal
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $datosSucursal = request()->except(['_token', '_method']);

        Sucursal::where('id', '=', $id)->update($datosSucursal);

        //$sucursal = Sucursal::findOrFail($id);
        //return view('Sucursal.Sucursal_edit',compact('sucursal'));
        $sucursales = Sucursal::all();

        return view('Sucursal.Sucursal_list', compact('sucursales'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Sucursal  $sucursal
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        //Sucursal::destroy($id);

        $sucursales = Sucursal::all();

        error_log('Some message here.');

        return view('Sucursal.Sucursal_list', compact('sucursales'));
    }
}
