<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;

class Cliente extends Authenticatable
{
    
    public $table = 'clientes';
    
    protected $fillable = [
        'nombre',
        'apellido',
        'codigo',
        'celular',
        'email',
        'password',
        'api_token',
        'device_token',
        'IsAdult',
        'ultimocodigo',
        'status',
		'vinculado',
		'apellido_paterno',
		'apellido_materno',
		'fecha_nacimiento',
		'registradofoliatti',
        'img_profile',
        'firebase_token'
    ];
    
    protected $casts = [
        'nombre' => 'string',
        'apellido' => 'string',        
        'celular' => 'string',
        'email' => 'string',
        'password' => 'string',
        'api_token' => 'string',
        'device_token' => 'string',
        'remember_token' => 'string',
        'img_profile' => 'string',
        'firebase_token' => 'string',
    ];
    
    protected $hidden = [
        'password',
        'remember_token',
    ];


    public function cliente_sucursal()
    {
        return $this->hasMany('App\Models\ClienteSucursal', 'idcliente', 'id');
    }

}
