<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LayoutEvento extends Model
{
    public $table = 'layout_evento';

    public $fillable = [
        'id',
        'nombre',
        'idsucursal',
        'sillas',   
        'status',
        'espacio',  
        'created_at',
        'updated_at',
        'deleted_at',
        'capacidad',
    ];


    public function layoutEventoMesa()
    {
        return $this->hasMany(LayoutEventoMesa::class, 'idlayout_evento');
    }

    public function layoutEventoSeccion()
    {
        return $this->hasMany(LayoutEventoSeccion::class, 'idlayout_evento');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }    

}
