<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VehiculoHistorial extends Model
{
    public $table = 'vehiculo_historial';
    
    protected $fillable = [
        'idvehiculo',
        'placas',
        'idcompany',
        'idsucursal',
        'idmarca',
        'idlinea',
        'idcolor',
        'modelo',
        'observaciones',
        'img_frente',
        'img_izq',
        'img_der',
        'img_atras',
        'status',
    ];
    
    protected $casts = [
        'placas' => 'string',
        'modelo' => 'string',        
        'img_frente' => 'string',
        'img_izq' => 'string',
        'img_der' => 'string',
        'img_atras' => 'string',
    ];

    public function marca()
    {
        return $this->belongsTo(\App\Models\Marca::class, 'idmarca', 'id');
    }

    public function linea()
    {
        return $this->belongsTo(\App\Models\Linea::class, 'idlinea', 'id');
    }

    public function color()
    {
        return $this->belongsTo(\App\Models\Color::class, 'idcolor', 'id');
    }
}
