<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('idcompany')->nullable()->unsigned();
            $table->integer('idsucursal')->nullable()->unsigned();
            $table->string('nombre', 100)->nullable();
            $table->string('apellido', 100)->nullable();
            $table->string('codigo', 50)->nullable();
            $table->string('celular', 100)->nullable()->unique();
            $table->string('email')->nullable()->unique();
            $table->string('password')->nullable();
            $table->char('api_token', 60)->unique()->nullable()->default(null);
            $table->string('device_token')->nullable();            
            $table->boolean('status')->nullable();
            $table->integer('idempleo')->nullable();
            $table->foreign('idsucursal')->references('id')->on('sucursal')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idcompany')->references('id')->on('company')->onDelete('cascade')->onUpdate('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
