<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEstacionamientoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('estacionamiento', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('idsucursal')->nullable()->unsigned();
            $table->string('nombre', 100)->nullable();
            $table->string('codigo', 50)->nullable();
            $table->boolean('activo')->nullable();+
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('idsucursal')->references('id')->on('sucursal')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('estacionamiento');
    }
}
