<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIticketValetTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('iticket_valet', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('iditicket')->nullable()->unsigned();
            $table->integer('idempleado')->nullable()->unsigned();
            $table->integer('idstatusvehiculo')->nullable()->unsigned();
            $table->integer('idestacionamientocajon')->nullable()->unsigned();
            $table->text('detalles')->nullable();
            $table->dateTime('fecha_asignacion')->nullable();
            $table->dateTime('fecha_inicio')->nullable();
            $table->dateTime('fecha_fin')->nullable();
            $table->timestamps();
            $table->foreign('iditicket')->references('id')->on('iticket')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idempleado')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idstatusvehiculo')->references('id')->on('statusvehiculo')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('idestacionamientocajon')->references('id')->on('estacionamientocajon')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('iticket_valet');
    }
}
