<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('reservacion_venta', function (Blueprint $table) {
            $table->id();
            $table->integer('id_evento');
            $table->date('fecha');
            $table->string('nombre');
            $table->string('telefono');
            $table->string('folio');
            $table->bool('tipo')->comment('0.- reservacion, 1.- venta');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('reservacion_venta');
    }
};
