@extends('layout')

@section('content')
    <script>
        $('body').on('click','#eliminar_asientos', function(e){
            $('#lugares').val('');
        });

        $('body').on('change','#evento', function(e){
            var $this = $(this);
            $('#lugares').val('');

            $.ajax({
                url: $this.attr("data-ruta"),
                type: "POST",
                data: {
                    _token : $('meta[name="csrf-token"]').attr('content'),
                    "dato" : $this.val(),
                },
                beforeSend: function(){
                    $("#div_mesas").html('<div class="d-flex justify-content-center"><div class="spinner-border" role="status" style="margin-right: 2%;"></div>...Cargando mesas</div>');
                }
            }).done(function (response) {
                $("#div_mesas").html(response.html);

                console.log(response);
            }).fail(function (response) {
                console.log("fallo");
                console.log(response);
            });
        })

        $('body').on('submit','.form_guardar', function(e){
            e.preventDefault();

            formData = new FormData(document.getElementById($(this).attr('id')));
            var url = $(`#${$(this).attr('id')}`).attr('action');

            var lugares = $('#lugares').val();
            var evento = $('#evento option:selected').text();
            var nombre = $('#nombre').val();
            var telefono = $('#telefono').val();

            Swal.fire({
                icon: "question",
                html: `<p>Estás por <b>confirmar</b> los lugares:</p>
                    <p><b>${lugares}</b>,</p>
                    <p>Del evento:</p>
                    <p><b>${evento}</b>,</p>
                    <p>A nombre de:</p>
                    <p><b>${nombre}</b>,</p>
                    <p>Contacto:</p>
                    <p><b>${telefono}</b></p>
                    <p><b>¿Deseas continuar?</b></p>
                `,
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: "Sí, confirmar",
                denyButtonText: `No, cancelar`,
                width: '65%',
                didOpen: () => {
                    document.querySelector('.swal2-html-container').style.maxHeight = '390px';
                }
            }).then((result) => {
                if (result.isConfirmed)
                {
                    $.ajax({
                        type:'POST',
                        url:url,
                        contentType: false,
                        processData: false,
                        datatype: "JSON",
                        data: formData,
                        beforeSend: function(){
                            $("#btn_guardar").val("Enviando..");
                            $("#btn_guardar").attr("disabled","disabled");
                        }
                    }).done(function (response) {
                        Swal.fire({
                            icon: response.icon,
                            title: response.title,
                            text: response.text,
                        });

                        $(location).attr('href',response.ruta);
                        console.log(response);
                    }).fail(function (response) {
                        console.log("fallo");
                        console.log(response);

                        $(".error").remove();

                        $.each(response.responseJSON.errors, function (index, value) {
                            $("#" + index).after('<span class="error form-text text-danger"><b>'+value+'</b></span>');
                        });
                    });
                }
                else if (result.isDenied)
                {
                    Swal.fire("Se cancelo la reservación", "", "info");
                }
            });

            $("#btn_guardar").val("Guardar");
            $("#btn_guardar").attr("disabled",false);
        })
    </script>
    <div class="card card-custom">
        <div class="card-header card-header-tabs-line nav-tabs-line-3x">
            <div class="card-toolbar">
                <ul class="nav nav-tabs nav-bold nav-tabs-line nav-tabs-line-3x">
                    <li class="nav-item mr-3">
                        <a class="nav-link active" data-toggle="tab" href="#kt_user_edit_tab_1">
                            <span class="nav-icon">
                                <span class="svg-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <polygon points="0 0 24 0 24 24 0 24" />
                                            <path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#000000" fill-rule="nonzero" />
                                            <path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#000000" opacity="0.3" />
                                        </g>
                                    </svg>
                                </span>
                            </span>
                            <span class="nav-text font-size-lg">Reservaciones y ventas</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="card-body">
            <div class="tab-content">
                <div class="tab-pane show active px-7" id="kt_user_edit_tab_1" role="tabpanel">
                    <form method="POST" action="{{ $editar ? route('actualizar_reservacion', $evento['id']) : route('guardar_reservacion') }}" class="form_guardar" id="form_guardar_reservacion" enctype="multipart/form-data">
                        @csrf
                        <div class="row text-center">
                            <div class="col-xl-12 mb-4">
                                <div class="form-row">
                                    <div class="form-group row col-12">
                                        <label class="col-3 form-label col text-lg-right text-left">Seleccione el evento</label>
                                        <div class="col-9">
                                            <div class="input-group input-group-lg input-group-solid">
                                                <select name="evento" id="evento" class="form-control form-control-lg form-control-solid" data-ruta="{{ route('mesas_posicion') }}">
                                                    <option disabled selected>-- Seleccione una opción --</option>
                                                    @foreach ($eventos as $item)
                                                        <option value="{{ $item->id }}">{{ $item->nombre }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group row col-5">
                                        <label class="col-form-label col-3 text-lg-right text-left">Nombre</label>
                                        <div class="col-9">
                                            <input name="nombre" id="nombre" class="form-control form-control-lg form-control-solid" type="text" />
                                        </div>
                                    </div>
                                    <div class="form-group row col-7">
                                        <label class="col-form-label col-3 text-lg-right text-left">Lugares seleccionados</label>
                                        <div class="col-9">
                                            <div class="input-group">
                                                <input type="text" class="form-control form-control-lg form-control-solid" name="lugares" id="lugares" readonly>
                                                <div class="input-group-append">
                                                    <button class="btn btn-danger" type="button" id="eliminar_asientos">
                                                        <svg width="24px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                            <g fill="none" stroke="white" stroke-width="2">
                                                                <line x1="3" y1="3" x2="21" y2="21" />
                                                                <line x1="21" y1="3" x2="3" y2="21" />
                                                            </g>
                                                        </svg>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="lugaresArray" id="lugaresArray" readonly>
                                    </div>
                                    <div class="form-group row col-5">
                                        <label class="col-form-label col-3 text-lg-right text-left">Teléfono</label>
                                        <div class="col-9">
                                            <input name="telefono" id="telefono" class="form-control form-control-lg form-control-solid" type="text" />
                                        </div>
                                    </div>
                                    <div class="form-group row col-7">
                                        <label class="col-form-label col-3 text-lg-right text-left">Folio/Transacción</label>
                                        <div class="col-9">
                                            <input name="folio" id="folio" class="form-control form-control-lg form-control-solid" type="text" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-12 my-2 mb-4" id="div_mesas"></div>

                            <div class="col-xl-12 my-2 mt-5">
                                <div class="form-group row mb-3">
                                    <div class="col-12">
                                        <button type="submit" class="btn btn-success" id="btn_guardar">{{ $editar ? "Actualizar" : "Guardar" }}</button>
                                        <a href="{{route('lista_reservacion')}}" class="btn btn-danger font-weight-bolder">Cancelar</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection