@php
    // Supongamos que $lugares_ocupados es un JSON y lo decodificamos
    $datos = json_decode($lugres_ocupados, true);
    $agrupados = [];

    // Agrupar los lugares por id_mesa_posicion
    foreach ($datos as $elemento) {
        $id = $elemento['id_mesa_posicion'];
        $lugar = $elemento['lugares'];

        if (!isset($agrupados[$id])) {
            $agrupados[$id] = [];
        }
        $agrupados[$id][] = $lugar;
    }

    // Convertir cada array de lugares en una cadena de texto
    foreach ($agrupados as $key => $value) {
        $agrupados[$key] = implode(', ', $value);
    }
@endphp
<style>
    .cuadricula {
        display: grid;
        grid-template-columns: repeat(19, 1fr);
        grid-template-rows: repeat(14, 1fr);
        width: 70vw;
        height: 70vh;
        gap: 1px;
        box-sizing: border-box;
        border: 1px solid #ccc;
    }

    .cuadro {
        border: 1px solid #aaa;
        display: flex;
        justify-content: center;
        align-items: center;
        font-size: calc(0.5vw + 0.5vh);
    }

    .diagram-container {
        position: relative;
        width: 135px;
        height: 116px;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-wrap: wrap;
    }

    .diagram-square {
        width: 50px;
        height: 50px;
        order: 2;
    }

    .diagram-letter {
        position: absolute;
        font-size: 16px;
        font-family: Arial, sans-serif;
        width: 25px;
        text-align: center;
    }

    #diagram-a {
        top: 50%;
        left: 0;
        transform: translateY(-50%);
        order: 1;
    }

    #diagram-b {
        top: 0;
        left: 50%;
        transform: translateX(-50%);
        order: 3;
    }

    #diagram-c {
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        order: 4;
    }

    #diagram-d {
        top: 50%;
        right: 0;
        transform: translateY(-50%);
        order: 5;
    }

</style>
<div class="cuadricula">
    @for ($i = 0; $i < 14 * 19; $i++)
        @foreach ($eventos as $item)
            @if ($i == $item->posicion)
                @php
                    $count = 0;  // Inicializa $count a 0 por defecto
                    if (isset($agrupados[$item->id]) && is_string($agrupados[$item->id])) {
                        $pieces = explode(", ", $agrupados[$item->id]);
                        $count = count($pieces);
                    }
                @endphp
                <div class="cuadro seleccionable" 
                    data-id="{{ $item->id }}" 
                    data-id_mesa="{{ $item->id_mesa }}" 
                    data-mesa="{{ $item->mesa }}" 
                    data-posicion="{{ $item->posicion }}" 
                    data-id_seccion="{{ $item->id_seccion }}" 
                    data-seccion="{{ $item->seccion }}" 
                    data-codigo="{{ $item->codigo }}" 
                    data-color="{{ $item->color }}" 
                    data-costo="{{ $evento->costo }}" 
                    data-posicionmesausado="{{ $agrupados[$item->id] ?? 'No disponible' }}"
                    style="background-color: {{ $count == 4 ? "#572364" : $item->color }}; color: #fff; cursor: pointer;">
                    {{ $item->codigo }}
                </div>
                @break
            @endif

            @if ($loop->last)
                <div class="cuadro" data-posicionmesa="{{ $i+1 }}" style="background-color: #f0f0f0; color: #333;">
                    {{-- $item->codigo --}}
                </div>
            @endif
        @endforeach
    @endfor
</div>
<script>
    // Función para formatear el número como moneda
    function formatAsCurrency(amount) {
        return '$' + parseFloat(amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
    }

    $('body').on('click','.seleccionable', function(e){
        var $this = $(this);
        var costo = $this.attr("data-costo");
        var seccion = $this.attr("data-seccion");
        var status = 'Disponible';
        /* var costo = formatAsCurrency(costo); */

        // Reemplazar "<br>" por un delimitador único para evitar problemas de parsing
        var lineas = costo.split('<br>');  // Dividimos el string por cada salto de línea

        // Filtrar las líneas que contienen exactamente la sección seleccionada
        var lineasFiltradas = lineas.filter(function(linea) {
            // Verificamos si la línea contiene la sección (zona1, zona2, etc.)
            return linea.trim().startsWith(seccion);
        });

        // Unir las líneas filtradas de nuevo en una cadena con <br> para cada línea
        var costoFiltrado = lineasFiltradas.join('<br>');

        // Supongamos que esto extrae una cadena como " valor1, valor2, valor3 "
        var datosPosicionUsados = $this.attr("data-posicionmesausado");

        // Dividir la cadena por comas y limpiar los espacios
        var posiciones = datosPosicionUsados.split(',').map(function(item) {
            return item.trim();  // Elimina espacios al inicio y al final de cada elemento
        });

        posiciones.forEach(function(codigo) {
            const ultimaLetra = codigo.trim().slice(-1);
            $('#exampleRadios' + ultimaLetra.toUpperCase()).prop('checked', true).prop('disabled', false);
        });

        var tawidth;
        
        let htmlContent = `
                    <div class="container">
                        <div class="row">
                            <!-- Panel de diagramas responsivo -->
                            <div class="col-md-4 text-center">
                                <div class="diagram-container" style="position: relative; width: 100%; padding-top: 100%; margin: auto;">
                                    <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 50%; height: 50%;">
                                        <div class="diagram-square" style="background-color: ${$this.attr("data-color")}; width: 100%; height: 100%;"></div>
                                    </div>
                                    <!-- Iterar sobre las letras A, B, C, D -->
                                    ${['A', 'B', 'C', 'D'].map(letter => `
                                    <div class="diagram-letter" style="position: absolute; width: 50%; height: 50%; ${getPositionStyle(letter)}">
                                        <div class="form-check" style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">
                                            <input class="form-check-input" type="checkbox" name="exampleRadios" 
                                                id="exampleRadios${letter}" 
                                                value="option${letter}"
                                                ${posiciones.includes(letter) ? 'checked disabled' : 'disabled'}>
                                            <label class="form-check-label" for="exampleRadios${letter}">
                                                ${letter}
                                            </label>
                                        </div>
                                    </div>
                                    `).join('')}
                                </div>
                            </div>`;

        if ($(window).width() < 769 && $(window).height() < 849)
        {
            tawidth='100%';
            htmlContent += `
                <!-- Tabla de sillas responsiva -->
                <div class="col-12 mt-5">
                    <ul class="list-group">
                        ${['A', 'B', 'C', 'D'].map(letter => `
                        <li class="list-group-item">
                            <strong>Silla:</strong><br>
                            <input type="checkbox" class="form-check-input" id="sillas${letter}" name="sillas[]" value="${$this.attr("data-posicion")}.${$this.attr("data-codigo")}${letter}" ${posiciones.includes(letter) ? 'checked disabled' : ''}>
                            <label class="form-check-label" for="sillas${letter}">${$this.attr("data-codigo")} ${letter}</label><br><br>
                            <strong>Costo:</strong><br> <b>${costoFiltrado}</b><br><br>
                            <strong>Status:</strong><br> ${posiciones.includes(letter) ? `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24" /><circle cx="12" cy="12" r="10" fill="none" stroke="red" stroke-width="2"/><line x1="15" y1="9" x2="9" y2="15" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><line x1="9" y1="9" x2="15" y2="15" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></g></svg>` : `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24" /><path d="M9 12l2 2l4-4" fill="none" stroke="green" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><circle cx="12" cy="12" r="10" fill="none" stroke="green" stroke-width="2"/></g></svg>`}
                        </li>
                        `).join('')}
                    </ul>
                </div>
            `;
        }
        else
        {
            tawidth='75%';
            htmlContent += `
                <!-- Tabla de sillas responsiva -->
                <div class="col-6 col-md-8 mt-5">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th scope="col">Silla</th>
                                    <th scope="col">Costo</th>
                                    <th scope="col">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                ${['A', 'B', 'C', 'D'].map(letter => `
                                <tr>
                                    <td>
                                        <input type="checkbox" class="form-check-input" id="sillas${letter}" name="sillas[]" value="${$this.attr("data-posicion")}.${$this.attr("data-codigo")}${letter}" ${posiciones.includes(letter) ? 'checked disabled' : ''}>
                                        <label class="form-check-label" for="sillas${letter}">${$this.attr("data-codigo")} ${letter}</label>
                                    </td>
                                    <td><b>${costoFiltrado}</b></td>
                                    <td>
                                        ${posiciones.includes(letter) ? `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24" /><circle cx="12" cy="12" r="10" fill="none" stroke="red" stroke-width="2"/><line x1="15" y1="9" x2="9" y2="15" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><line x1="9" y1="9" x2="15" y2="15" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></g></svg>` : `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="24" height="24" /><path d="M9 12l2 2l4-4" fill="none" stroke="green" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><circle cx="12" cy="12" r="10" fill="none" stroke="green" stroke-width="2"/></g></svg>`}
                                    </td>
                                </tr>
                                `).join('')}
                            </tbody>
                        </table>
                    </div>
                </div>
            `;
        }

        htmlContent += `
                    </div>
                </div>`;

        const swalConfig = {
            title: "<strong>" + $this.attr("data-mesa") + "<br>Codigo: " + $this.attr("data-codigo") + "<br>Sección: " + $this.attr("data-seccion") + "</strong>",
            html: htmlContent,
            showCloseButton: true,
            showCancelButton: true,
            focusConfirm: false,
            confirmButtonText: 'Aceptar',
            cancelButtonText: 'Cancelar',
            width: tawidth,
            didOpen: () => {
                document.querySelector('.swal2-html-container').style.maxHeight = '260px';
            }
        };

        function getPositionStyle(letter) {
            switch(letter) {
                case 'A': return "top: 0; left: 50%; transform: translate(-50%, -50%) rotate(0deg);";
                case 'B': return "top: 50%; left: 100%; transform: translate(-50%, -50%) rotate(0deg);";
                case 'C': return "top: 100%; left: 50%; transform: translate(-50%, -50%) rotate(0deg);";
                case 'D': return "top: 50%; left: 0; transform: translate(-50%, -50%) rotate(0deg);";
                default: return "";
            }
        }

        function openSwal() {
            Swal.fire(swalConfig).then((result) => {
                if (result.isConfirmed) {
                    if ($('input[name="sillas[]"]:checked').length > 0) {
                        // Obtener las sillas seleccionadas
                        var sillasSeleccionadas = $('input[name="sillas[]"]:checked').map(function() {
                            return this.value;
                        }).get();

                        let datosActuales = $('#lugaresArray').val().trim();
                        let arrayDatos = datosActuales.length > 0 ? datosActuales.split(', ') : [];

                        let dataId = $this.attr("data-id"); // Obtener el data-id
                        let existingData = $('#lugaresArray').val().trim(); // Obtener datos actuales del input

                        // Convertir los datos existentes de JSON a objeto, si no está vacío
                        let dataObject = existingData ? JSON.parse(existingData) : {};

                        // Agregar o actualizar los datos para el data-id específico
                        if (!dataObject[dataId]) {
                            dataObject[dataId] = [];
                        }

                        // Agregar las filas seleccionadas a la tabla y al JSON
                        sillasSeleccionadas.forEach(function(silla) {
                            var partes = silla.split('.'); // Dividir la posición y la silla

                            var posicion = partes[0];
                            var numeroSilla = partes[1];

                            // Verificar si la silla ya está seleccionada en la tabla
                            var existeEnTabla = false;
                            $('#tablaLugares tbody tr').each(function() {
                                var posTabla = $(this).find('td').eq(0).text();
                                var sillaTabla = $(this).find('td').eq(1).text();
                                if (posTabla === posicion && sillaTabla === numeroSilla) {
                                    existeEnTabla = true;
                                    return false; // Romper el bucle si se encuentra
                                }
                            });

                            if (existeEnTabla) {
                                // Mostrar alerta de que la silla ya está seleccionada
                                Swal.fire({
                                    icon: 'warning',
                                    title: 'Silla duplicada',
                                    text: `La silla ${numeroSilla} en la posición ${posicion} ya ha sido seleccionada.`,
                                    showConfirmButton: true
                                });
                            } else {
                                // Agregar la fila a la tabla con un botón para eliminar
                                var nuevaFila = `
                                    <tr>
                                        <td>${posicion}</td>
                                        <td>${numeroSilla}</td>
                                        <td>${costo}</td>
                                        <td><button type="button" class="btn btn-danger btn-sm eliminar-fila" data-posicion="${posicion}" data-silla="${numeroSilla}">Eliminar</button></td>
                                    </tr>
                                `;

                                $('#tablaLugares tbody').append(nuevaFila);

                                // Agregar a los datos en el JSON
                                if (!dataObject[dataId].includes(numeroSilla)) {
                                    dataObject[dataId].push(numeroSilla);
                                }
                            }
                        });

                        // Convertir el objeto actualizado a un string JSON y almacenarlo en el input hidden
                        let jsonString = JSON.stringify(dataObject);
                        $('#lugaresArray').val(jsonString);
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: '¡Error!',
                            text: 'Por favor, selecciona al menos una silla.',
                            preConfirm: () => {
                                openSwal();
                            }
                        });
                    }
                }
            });
        }

        // Evento para eliminar fila y actualizar el input lugaresArray
        $('body').on('click', '.eliminar-fila', function() {
            var posicion = $(this).data('posicion');
            var numeroSilla = $(this).data('silla');
            let dataId = $this.attr("data-id"); // Obtener el data-id

            // Eliminar la fila de la tabla
            $(this).closest('tr').remove();

            // Obtener el valor actual del input lugaresArray
            let existingData = $('#lugaresArray').val().trim();
            let dataObject = existingData ? JSON.parse(existingData) : {};

            // Remover la silla correspondiente del array en el JSON
            if (dataObject[dataId]) {
                dataObject[dataId] = dataObject[dataId].filter(function(silla) {
                    return silla !== numeroSilla;
                });

                // Si ya no quedan sillas en esta posición, eliminar la posición del objeto
                if (dataObject[dataId].length === 0) {
                    delete dataObject[dataId];
                }
            }

            // Convertir el objeto actualizado a un string JSON y almacenarlo en el input hidden
            let jsonString = JSON.stringify(dataObject);
            $('#lugaresArray').val(jsonString);
        });

        openSwal();
    });
</script>